<?php
include 'index.php';
?>
<section class="pc-container">
    <div class="pc-content">
        <div class="row">
            <div class="mb-4 d-flex justify-content-between align-items-center">
                <h2 class="mb-0">Data Obat</h2>
                <button class="btn btn-success rounded" data-bs-toggle="modal" data-bs-target="#addObatModal">
                    <i class="ti ti-plus"></i> Tambah Obat
                </button>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Daftar Obat</h5>
                        <small>Kelola data obat dan informasi stok per gudang</small>
                    </div>
                    <div class="card-body">
                        <div class="dt-responsive">
                            <table id="dom-jqry" class="table table-striped table-bordered nowrap">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Kode Obat</th>
                                        <th>Nama Obat</th>
                                        <th>Bentuk</th>
                                        <th>Satuan</th>
                                        <th>Harga Jual</th>
                                        <th>Total Stok</th>
                                        <th>Stok Min/Max</th>
                                        <th>Kadaluarsa</th>
                                        <th class="text-center">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $query = "SELECT o.*, 
                                              COALESCE(SUM(s.jumlah), 0) as total_stok
                                              FROM obat o
                                              LEFT JOIN stok s ON o.id_obat = s.id_obat
                                              GROUP BY o.id_obat
                                              ORDER BY o.id_obat DESC";
                                    $result = mysqli_query($conn, $query);
                                    $no = 1;
                                    while ($row = mysqli_fetch_assoc($result)) {
                                        // Cek status kadaluarsa
                                        $tgl_sekarang = date('Y-m-d');
                                        $tgl_kadaluarsa = $row['tgl_kadaluarsa'];
                                        $selisih_hari = (strtotime($tgl_kadaluarsa) - strtotime($tgl_sekarang)) / (60 * 60 * 24);
                                        
                                        $status_kadaluarsa = '';
                                        if ($selisih_hari < 0) {
                                            $status_kadaluarsa = '<span class="badge bg-danger">Kadaluarsa</span>';
                                        } elseif ($selisih_hari <= 90) {
                                            $status_kadaluarsa = '<span class="badge bg-warning">Segera Kadaluarsa</span>';
                                        } else {
                                            $status_kadaluarsa = '<span class="badge bg-success">Aman</span>';
                                        }
                                        
                                        // Cek status stok
                                        $status_stok = '';
                                        if ($row['total_stok'] < $row['stok_minimum']) {
                                            $status_stok = '<span class="badge bg-danger">Stok Kurang</span>';
                                        } elseif ($row['total_stok'] > $row['stok_maksimum']) {
                                            $status_stok = '<span class="badge bg-info">Stok Berlebih</span>';
                                        }
                                    ?>
                                    <tr>
                                        <td><?= $no++ ?></td>
                                        <td><?= $row['kode_obat'] ?></td>
                                        <td><?= $row['nama_obat'] ?></td>
                                        <td><?= $row['bentuk'] ?></td>
                                        <td><?= $row['satuan'] ?></td>
                                        <td>Rp <?= number_format($row['harga_jual'], 0, ',', '.') ?></td>
                                        <td>
                                            <strong><?= $row['total_stok'] ?></strong>
                                            <?= $status_stok ?>
                                        </td>
                                        <td><?= $row['stok_minimum'] ?> / <?= $row['stok_maksimum'] ?></td>
                                        <td><?= $status_kadaluarsa ?></td>
                                        <td class="text-center">
                                            <button class="btn btn-info btn-sm" data-bs-toggle="modal" data-bs-target="#detailObatModal<?php echo $row['id_obat']; ?>" title="Detail">
                                                <i class="ti ti-eye"></i>
                                            </button>
                                            <button class="btn btn-secondary btn-sm" data-bs-toggle="modal" data-bs-target="#barcodeModal<?php echo $row['id_obat']; ?>" title="Barcode">
                                                <i class="ti ti-barcode"></i>
                                            </button>
                                            <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#editObatModal<?php echo $row['id_obat']; ?>" title="Edit">
                                                <i class="ti ti-edit"></i>
                                            </button>
                                            <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteObatModal<?php echo $row['id_obat']; ?>" title="Hapus">
                                                <i class="ti ti-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Modal Tambah Obat -->
<div class="modal fade" id="addObatModal" tabindex="-1" aria-labelledby="addObatModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addObatModalLabel">Tambah Obat</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="addObatForm" action="tambahobat.php" method="POST">
                <div class="modal-body">
                    <h6 class="mb-3 text-primary"><i class="ti ti-pill"></i> Data Obat</h6>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="kode_obat" class="form-label">Kode Obat <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="kode_obat" name="kode_obat" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="nama_obat" class="form-label">Nama Obat <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="nama_obat" name="nama_obat" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="bentuk" class="form-label">Bentuk <span class="text-danger">*</span></label>
                                <select class="form-select" id="bentuk" name="bentuk" required>
                                    <option value="">Pilih Bentuk</option>
                                    <option value="Tablet">Tablet</option>
                                    <option value="Kapsul">Kapsul</option>
                                    <option value="Sirup">Sirup</option>
                                    <option value="Injeksi">Injeksi</option>
                                    <option value="Salep">Salep</option>
                                    <option value="Krim">Krim</option>
                                    <option value="Tetes">Tetes</option>
                                    <option value="Kaplet">Kaplet</option>
                                    <option value="Suspensi">Suspensi</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="satuan" class="form-label">Satuan <span class="text-danger">*</span></label>
                                <select class="form-select" id="satuan" name="satuan" required>
                                    <option value="">Pilih Satuan</option>
                                    <option value="Strip">Strip</option>
                                    <option value="Box">Box</option>
                                    <option value="Botol">Botol</option>
                                    <option value="Tube">Tube</option>
                                    <option value="Ampul">Ampul</option>
                                    <option value="Vial">Vial</option>
                                    <option value="Sachet">Sachet</option>
                                    <option value="Pot">Pot</option>
                                    <option value="Kaleng">Kaleng</option>
                                    <option value="Pcs">Pcs</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="harga_beli" class="form-label">Harga Beli <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="harga_beli" name="harga_beli" min="0" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="harga_jual" class="form-label">Harga Jual <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="harga_jual" name="harga_jual" min="0" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="stok_minimum" class="form-label">Stok Minimum <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="stok_minimum" name="stok_minimum" min="0" required>
                                <small class="text-muted">Batas minimal total stok</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="stok_maksimum" class="form-label">Stok Maksimum <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="stok_maksimum" name="stok_maksimum" min="0" required>
                                <small class="text-muted">Batas maksimal total stok</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="lead_time_hari" class="form-label">Lead Time (Hari) <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="lead_time_hari" name="lead_time_hari" min="0" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="tgl_kadaluarsa" class="form-label">Tanggal Kadaluarsa <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="tgl_kadaluarsa" name="tgl_kadaluarsa" required>
                            </div>
                        </div>
                    </div>
                    
                    <hr class="my-4">
                    
                    <h6 class="mb-3 text-primary"><i class="ti ti-building-warehouse"></i> Stok Awal di Gudang</h6>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="id_gudang" class="form-label">Pilih Gudang <span class="text-danger">*</span></label>
                                <select class="form-select" id="id_gudang" name="id_gudang" required>
                                    <option value="">-- Pilih Gudang --</option>
                                    <?php
                                    $query_gudang = "SELECT * FROM gudang ORDER BY nama_gudang ASC";
                                    $result_gudang = mysqli_query($conn, $query_gudang);
                                    while ($gudang = mysqli_fetch_assoc($result_gudang)) {
                                        echo '<option value="'.$gudang['id_gudang'].'">'.$gudang['nama_gudang'].' - '.$gudang['lokasi'].'</option>';
                                    }
                                    ?>
                                </select>
                                <small class="text-muted">Pilih gudang untuk menyimpan stok awal</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="jumlah_stok_awal" class="form-label">Jumlah Stok Awal <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="jumlah_stok_awal" name="jumlah_stok_awal" min="0" value="0" required>
                                <small class="text-muted">Masukkan 0 jika belum ada stok</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="alert alert-info mb-0">
                        <i class="ti ti-info-circle"></i> <strong>Informasi:</strong>
                        <ul class="mb-0 mt-2">
                            <li>Barcode akan di-generate otomatis menggunakan Picqer</li>
                            <li>Stok awal akan ditambahkan ke gudang yang dipilih</li>
                            <li>Anda bisa menambah stok ke gudang lain melalui menu Stok Gudang</li>
                        </ul>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Tutup</button>
                    <button type="submit" class="btn btn-success" name="tambah"><i class="ti ti-device-floppy"></i> Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
    $query = "SELECT o.*, 
              COALESCE(SUM(s.jumlah), 0) as total_stok
              FROM obat o
              LEFT JOIN stok s ON o.id_obat = s.id_obat
              GROUP BY o.id_obat
              ORDER BY o.id_obat DESC";
    $result = mysqli_query($conn, $query);
    while ($row = mysqli_fetch_assoc($result)) {
        // Get stok per gudang
        $query_stok = "SELECT s.*, g.nama_gudang, g.lokasi
                       FROM stok s 
                       JOIN gudang g ON s.id_gudang = g.id_gudang 
                       WHERE s.id_obat = " . $row['id_obat'] . "
                       ORDER BY g.nama_gudang ASC";
        $result_stok = mysqli_query($conn, $query_stok);
?>

<!-- Modal Detail Obat -->
<div class="modal fade" id="detailObatModal<?php echo $row['id_obat']; ?>" tabindex="-1" aria-labelledby="detailObatModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="detailObatModalLabel">Detail Obat - <?php echo $row['nama_obat']; ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <th width="40%">Kode Obat</th>
                                <td>: <?php echo $row['kode_obat']; ?></td>
                            </tr>
                            <tr>
                                <th>Nama Obat</th>
                                <td>: <?php echo $row['nama_obat']; ?></td>
                            </tr>
                            <tr>
                                <th>Bentuk</th>
                                <td>: <?php echo $row['bentuk']; ?></td>
                            </tr>
                            <tr>
                                <th>Satuan</th>
                                <td>: <?php echo $row['satuan']; ?></td>
                            </tr>
                            <tr>
                                <th>Harga Beli</th>
                                <td>: Rp <?php echo number_format($row['harga_beli'], 0, ',', '.'); ?></td>
                            </tr>
                            <tr>
                                <th>Harga Jual</th>
                                <td>: Rp <?php echo number_format($row['harga_jual'], 0, ',', '.'); ?></td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <th width="40%">Stok Minimum</th>
                                <td>: <?php echo $row['stok_minimum']; ?></td>
                            </tr>
                            <tr>
                                <th>Stok Maksimum</th>
                                <td>: <?php echo $row['stok_maksimum']; ?></td>
                            </tr>
                            <tr>
                                <th>Total Stok</th>
                                <td>: <strong class="text-primary"><?php echo $row['total_stok']; ?></strong></td>
                            </tr>
                            <tr>
                                <th>Lead Time</th>
                                <td>: <?php echo $row['lead_time_hari']; ?> Hari</td>
                            </tr>
                            <tr>
                                <th>Tanggal Kadaluarsa</th>
                                <td>: <?php echo date('d-m-Y', strtotime($row['tgl_kadaluarsa'])); ?></td>
                            </tr>
                            <tr>
                                <th>Barcode</th>
                                <td>: <?php echo $row['barcode']; ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
                <hr>
                <h6 class="mb-3"><i class="ti ti-building-warehouse"></i> Stok per Gudang</h6>
                <div class="table-responsive">
                    <table class="table table-bordered table-sm">
                        <thead class="table-light">
                            <tr>
                                <th>No</th>
                                <th>Nama Gudang</th>
                                <th>Lokasi</th>
                                <th class="text-end">Jumlah Stok</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $no_stok = 1;
                            $found_stok = false;
                            while ($stok = mysqli_fetch_assoc($result_stok)) { 
                                $found_stok = true;
                            ?>
                            <tr>
                                <td><?php echo $no_stok++; ?></td>
                                <td><?php echo $stok['nama_gudang']; ?></td>
                                <td><?php echo $stok['lokasi']; ?></td>
                                <td class="text-end"><strong><?php echo $stok['jumlah']; ?></strong></td>
                            </tr>
                            <?php } 
                            if (!$found_stok) {
                            ?>
                            <tr>
                                <td colspan="4" class="text-center text-muted">Belum ada stok di gudang manapun</td>
                            </tr>
                            <?php } ?>
                        </tbody>
                        <?php if ($found_stok) { ?>
                        <tfoot class="table-light">
                            <tr>
                                <th colspan="3" class="text-end">Total Stok:</th>
                                <th class="text-end text-primary"><?php echo $row['total_stok']; ?></th>
                            </tr>
                        </tfoot>
                        <?php } ?>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Barcode -->
<div class="modal fade" id="barcodeModal<?php echo $row['id_obat']; ?>" tabindex="-1" aria-labelledby="barcodeModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="barcodeModalLabel">Barcode - <?php echo $row['nama_obat']; ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                <div id="barcodeContainer<?php echo $row['id_obat']; ?>" class="mb-3">
                    <?php
                    $barcodePath = "assets/images/barcode/" . $row['barcode'];
                    if (file_exists($barcodePath) && !empty($row['barcode'])) {
                        echo '<img src="' . $barcodePath . '" alt="Barcode" class="img-fluid" style="max-width: 300px;">';
                    } else {
                        echo '<div class="alert alert-warning">Gambar barcode tidak ditemukan</div>';
                    }
                    ?>
                </div>
                <p class="mb-1"><strong><?php echo $row['kode_obat']; ?></strong></p>
                <p class="text-muted mb-2"><?php echo $row['nama_obat']; ?></p>
                <p class="mb-1">Harga: <strong class="text-success">Rp <?php echo number_format($row['harga_jual'], 0, ',', '.'); ?></strong></p>
                <p class="mb-0">Total Stok: <strong class="text-primary"><?php echo $row['total_stok']; ?> <?php echo $row['satuan']; ?></strong></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Tutup</button>
                <button type="button" class="btn btn-primary" onclick="printBarcode(
                        '<?php echo $row['id_obat']; ?>',
                        '<?php echo $row['nama_obat']; ?>',
                        '<?php echo $row['kode_obat']; ?>',
                        '<?php echo $row['harga_jual']; ?>'
                    )">
                    <i class="ti ti-printer"></i> Cetak Barcode
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Edit Obat -->
<div class="modal fade" id="editObatModal<?php echo $row['id_obat']; ?>" tabindex="-1" aria-labelledby="editObatModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editObatModalLabel">Edit Obat</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="editObatForm" action="editobat.php" method="POST">
                <input type="hidden" name="id_obat" value="<?php echo $row['id_obat']; ?>">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_kode_obat<?php echo $row['id_obat']; ?>" class="form-label">Kode Obat</label>
                                <input type="text" class="form-control" id="edit_kode_obat<?php echo $row['id_obat']; ?>" name="kode_obat" value="<?php echo $row['kode_obat']; ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_nama_obat<?php echo $row['id_obat']; ?>" class="form-label">Nama Obat</label>
                                <input type="text" class="form-control" id="edit_nama_obat<?php echo $row['id_obat']; ?>" name="nama_obat" value="<?php echo $row['nama_obat']; ?>" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_bentuk<?php echo $row['id_obat']; ?>" class="form-label">Bentuk</label>
                                <select class="form-select" id="edit_bentuk<?php echo $row['id_obat']; ?>" name="bentuk" required>
                                    <option value="Tablet" <?php echo $row['bentuk'] == 'Tablet' ? 'selected' : ''; ?>>Tablet</option>
                                    <option value="Kapsul" <?php echo $row['bentuk'] == 'Kapsul' ? 'selected' : ''; ?>>Kapsul</option>
                                    <option value="Sirup" <?php echo $row['bentuk'] == 'Sirup' ? 'selected' : ''; ?>>Sirup</option>
                                    <option value="Injeksi" <?php echo $row['bentuk'] == 'Injeksi' ? 'selected' : ''; ?>>Injeksi</option>
                                    <option value="Salep" <?php echo $row['bentuk'] == 'Salep' ? 'selected' : ''; ?>>Salep</option>
                                    <option value="Krim" <?php echo $row['bentuk'] == 'Krim' ? 'selected' : ''; ?>>Krim</option>
                                    <option value="Tetes" <?php echo $row['bentuk'] == 'Tetes' ? 'selected' : ''; ?>>Tetes</option>
                                    <option value="Kaplet" <?php echo $row['bentuk'] == 'Kaplet' ? 'selected' : ''; ?>>Kaplet</option>
                                    <option value="Suspensi" <?php echo $row['bentuk'] == 'Suspensi' ? 'selected' : ''; ?>>Suspensi</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_satuan<?php echo $row['id_obat']; ?>" class="form-label">Satuan</label>
                                <select class="form-select" id="edit_satuan<?php echo $row['id_obat']; ?>" name="satuan" required>
                                    <option value="Strip" <?php echo $row['satuan'] == 'Strip' ? 'selected' : ''; ?>>Strip</option>
                                    <option value="Box" <?php echo $row['satuan'] == 'Box' ? 'selected' : ''; ?>>Box</option>
                                    <option value="Botol" <?php echo $row['satuan'] == 'Botol' ? 'selected' : ''; ?>>Botol</option>
                                    <option value="Tube" <?php echo $row['satuan'] == 'Tube' ? 'selected' : ''; ?>>Tube</option>
                                    <option value="Ampul" <?php echo $row['satuan'] == 'Ampul' ? 'selected' : ''; ?>>Ampul</option>
                                    <option value="Vial" <?php echo $row['satuan'] == 'Vial' ? 'selected' : ''; ?>>Vial</option>
                                    <option value="Sachet" <?php echo $row['satuan'] == 'Sachet' ? 'selected' : ''; ?>>Sachet</option>
                                    <option value="Pot" <?php echo $row['satuan'] == 'Pot' ? 'selected' : ''; ?>>Pot</option>
                                    <option value="Kaleng" <?php echo $row['satuan'] == 'Kaleng' ? 'selected' : ''; ?>>Kaleng</option>
                                    <option value="Pcs" <?php echo $row['satuan'] == 'Pcs' ? 'selected' : ''; ?>>Pcs</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_harga_beli<?php echo $row['id_obat']; ?>" class="form-label">Harga Beli</label>
                                <input type="number" class="form-control" id="edit_harga_beli<?php echo $row['id_obat']; ?>" name="harga_beli" value="<?php echo $row['harga_beli']; ?>" min="0" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_harga_jual<?php echo $row['id_obat']; ?>" class="form-label">Harga Jual</label>
                                <input type="number" class="form-control" id="edit_harga_jual<?php echo $row['id_obat']; ?>" name="harga_jual" value="<?php echo $row['harga_jual']; ?>" min="0" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="edit_stok_minimum<?php echo $row['id_obat']; ?>" class="form-label">Stok Minimum</label>
                                <input type="number" class="form-control" id="edit_stok_minimum<?php echo $row['id_obat']; ?>" name="stok_minimum" value="<?php echo $row['stok_minimum']; ?>" min="0" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="edit_stok_maksimum<?php echo $row['id_obat']; ?>" class="form-label">Stok Maksimum</label>
                                <input type="number" class="form-control" id="edit_stok_maksimum<?php echo $row['id_obat']; ?>" name="stok_maksimum" value="<?php echo $row['stok_maksimum']; ?>" min="0" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="edit_lead_time_hari<?php echo $row['id_obat']; ?>" class="form-label">Lead Time (Hari)</label>
                                <input type="number" class="form-control" id="edit_lead_time_hari<?php echo $row['id_obat']; ?>" name="lead_time_hari" value="<?php echo $row['lead_time_hari']; ?>" min="0" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="edit_tgl_kadaluarsa<?php echo $row['id_obat']; ?>" class="form-label">Tanggal Kadaluarsa</label>
                                <input type="date" class="form-control" id="edit_tgl_kadaluarsa<?php echo $row['id_obat']; ?>" name="tgl_kadaluarsa" value="<?php echo $row['tgl_kadaluarsa']; ?>" required>
                            </div>
                        </div>
                    </div>
                    <div class="alert alert-warning">
                        <i class="ti ti-info-circle"></i> <strong>Catatan:</strong> Barcode tidak dapat diubah. Barcode saat ini: <strong><?php echo $row['barcode']; ?></strong>
                    </div>
                    <div class="alert alert-info">
                        <i class="ti ti-info-circle"></i> <strong>Info Stok:</strong> Stok dikelola terpisah melalui menu Stok Gudang. Total stok saat ini: <strong><?php echo $row['total_stok']; ?></strong>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Tutup</button>
                    <button type="submit" class="btn btn-warning" name="edit"><i class="ti ti-device-floppy"></i> Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Hapus Obat -->
<div class="modal fade" id="deleteObatModal<?php echo $row['id_obat']; ?>" tabindex="-1" aria-labelledby="deleteObatModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteObatModalLabel"><i class="ti ti-alert-triangle"></i> Konfirmasi Hapus</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="deleteObatForm" action="hapusobat.php" method="POST">
                <input type="hidden" name="id_obat" value="<?php echo $row['id_obat']; ?>">
                <div class="modal-body">
                    <p>Apakah Anda yakin ingin menghapus obat <strong><?php echo $row['nama_obat']; ?></strong>?</p>
                    <?php if ($row['total_stok'] > 0) { ?>
                    <div class="alert alert-danger">
                        <i class="ti ti-alert-triangle"></i> <strong>Perhatian!</strong> 
                        <br>Obat ini masih memiliki stok sebanyak <strong><?php echo $row['total_stok']; ?> <?php echo $row['satuan']; ?></strong> di gudang. 
                        <br><strong>Semua data stok akan ikut terhapus!</strong>
                    </div>
                    <?php } ?>
                    <div class="alert alert-warning">
                        <i class="ti ti-alert-triangle"></i> <strong>Data yang dihapus tidak dapat dikembalikan!</strong>
                        <ul class="mb-0 mt-2">
                            <li>Data obat akan dihapus permanent</li>
                            <li>Semua stok di seluruh gudang akan terhapus</li>
                            <li>File barcode akan dihapus</li>
                        </ul>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-danger" name="hapus"><i class="ti ti-trash"></i> Ya, Hapus</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php } ?>

<script>
function printBarcode(id_obat, nama_obat, kode_obat, harga_jual) {
    var barcodeContainer = document.getElementById('barcodeContainer' + id_obat);
    
    if (!barcodeContainer) {
        alert('Elemen barcode tidak ditemukan!');
        return;
    }
    
    var printContents = barcodeContainer.innerHTML;
    
    var printWindow = window.open('', '_blank', 'width=600,height=600');
    printWindow.document.write(`
        <!DOCTYPE html>
        <html>
        <head>
            <title>Cetak Barcode - ${nama_obat}</title>
            <style>
                body { 
                    font-family: Arial, sans-serif; 
                    text-align: center; 
                    padding: 20px;
                    margin: 0;
                }
                .barcode-container { 
                    margin: 20px auto; 
                    max-width: 350px;
                    border: 2px dashed #ccc;
                    padding: 20px;
                    border-radius: 10px;
                }
                .barcode-image {
                    max-width: 100%;
                    height: auto;
                }
                .product-info {
                    margin: 15px 0;
                    font-size: 16px;
                    font-weight: bold;
                }
                .barcode-number {
                    font-size: 18px;
                    font-weight: bold;
                    margin: 10px 0;
                    letter-spacing: 3px;
                    color: #333;
                }
                .price {
                    font-size: 16px;
                    color: #28a745;
                    font-weight: bold;
                    margin: 10px 0;
                }
                .header {
                    font-size: 12px;
                    color: #666;
                    margin-bottom: 10px;
                }
                @media print {
                    body { margin: 0; padding: 10px; }
                    .no-print { display: none; }
                    .barcode-container {
                        border: 2px solid #000;
                    }
                }
            </style>
        </head>
        <body>
            <div class="barcode-container">
                <div class="header">APOTEK BARCODE</div>
                <div class="product-info">${nama_obat}</div>
                <div class="barcode-content">
                    ${printContents}
                </div>
                <div class="barcode-number">${kode_obat}</div>
                <div class="price">Rp ${formatRupiah(harga_jual)}</div>
            </div>
            <div class="no-print" style="margin-top: 20px;">
                <button onclick="window.print()" style="padding: 10px 20px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 14px;">
                    🖨️ Cetak
                </button>
                <button onclick="window.close()" style="padding: 10px 20px; background: #dc3545; color: white; border: none; border-radius: 5px; cursor: pointer; margin-left: 10px; font-size: 14px;">
                    ❌ Tutup
                </button>
            </div>
            
            <script>
                function formatRupiah(angka) {
                    return angka.toString().replace(/\\B(?=(\\d{3})+(?!\\d))/g, ".");
                }
            <\/script>
        </body>
        </html>
    `);
    
    printWindow.document.close();
}

function formatRupiah(angka) {
    return angka.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
}
</script>

<?php include 'footer.php'; ?>